﻿using System;
using System.Collections.Generic;
using System.Web.UI;
using Microsoft.Reporting.WebForms;
using System.Linq;
using System.Web.UI.WebControls;
using System.Web;
using VIRP_WEB.BaseCode;
using VIRP_WEB.SoaServices;

namespace VIRP_WEB.Custom.EFR
{
    public partial class TefscLaboratoryRequestReport : EfrBasePage
    {
        List<ReportParameter> reportParameters = new List<ReportParameter>();

        private static IReadOnlyList<string> navigationSources = new List<string>
    {
        "/Custom/EFR/LabOrders/LabOrder.aspx",
        "/Custom/EFR/Patients/PatientWorkflows.aspx"
    };

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!AccessAllowed())
            {
                Response.Redirect("ErrorPage.aspx?id=100");
            }

            if (!Page.IsPostBack)
            {
                ReportViewerTefscLaboratoryRequest.Reset();
                ReportViewerTefscLaboratoryRequest.ProcessingMode = ProcessingMode.Remote;
                ReportViewerTefscLaboratoryRequest.ServerReport.Timeout = (Timeout * 1000); //this timeout is in milliseconds
                ReportViewerTefscLaboratoryRequest.ServerReport.ReportServerUrl = new Uri(ReportServerUrl);
                ReportViewerTefscLaboratoryRequest.ServerReport.ReportPath = "/Reports/EFR/Sub/TefscLaboratoryRequestReport";

                reportParameters.Clear();
                ReportParameter reportParamSetActivityId = new ReportParameter("activityId", Request.QueryString["activityId"]);
                reportParameters.Add(reportParamSetActivityId);

                ReportViewerTefscLaboratoryRequest.ServerReport.SetParameters(reportParameters);
                ReportViewerTefscLaboratoryRequest.ServerReport.Refresh();

                ViewState["referrer"] = Request.UrlReferrer;

                SetBreadCrumbs();
            }
        }
        private void SetBreadCrumbs()
        {
            WKF_CASE_ACTIVITY activity = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, int.Parse(Request.QueryString["activityId"]));
            ((Label)Master.FindControl("EfrPageTitle")).Text = "My Tasks > Lab Orders > Closed > Workflow ID " + activity.WKF_CASE_ID.ToString();
        }

        private bool AccessAllowed()
        {
            return true;
        }

        protected void Cancel_Click(object sender, EventArgs e)
        {
            Uri from = ViewState["referrer"] as Uri;
            if (from != null && navigationSources != null && navigationSources.Contains(from.LocalPath))
            {
                if (!string.IsNullOrEmpty(from.PathAndQuery))
                {
                    Response.Redirect(from.PathAndQuery);
                }
            }
        }
    }
}
